clc; clear; 

%% Problem Data
n = 2;

Q = [0.3   -0.7
    -0.7    2.0];

h  = [-1; .1];

% number of polygon sides
n_poly = 5;
% Ax = b, defines the polygon interior
A = zeros(n_poly,2);
b = zeros(n_poly,1);

% define polygon (n_poly points around a circle)
theta_poly = (0:(2*pi)/n_poly:2*pi);
x_poly = cos(theta_poly);
y_poly = 1.5*sin(theta_poly-pi/10);% rotate the y coord

% segments of circle define the polygon
for i = 1:n_poly

    % compute direction p = x2-x1
    p = [x_poly(i+1)-x_poly(i)
         y_poly(i+1)-y_poly(i)];

    % get the normal direction
    % rotate 90 degrees counter-clockwise
    a = [p(2),-p(1)];
    a = a/norm(a);

    A(i,:) = a;

    % offset of the polygon side
    b(i) = a*[x_poly(i); y_poly(i)];

end

% Q = eye(n);
% h = [-5;0];
% A = [1 0;-1 0;0 1;0 -1];
% b = ones(4,1);




%% Algorithm

options = optimoptions('quadprog','Algorithm','active-set','Display','off');
[x_qp,f_opt,exitflag,output,lambda] = quadprog(Q,h,A,b,[],[],[],[],[0;0],options);

% fprintf('Solution\n')
% disp(x_qp)
fprintf('Function value %.4e \n',f_opt)
fprintf('KKT multipliers \n')
disp(lambda.ineqlin')

%% Plotting

% Plot the QP
figure(1),clf, hold on, box on, grid on, axis equal
xlabel('x_1');
ylabel('x_2');
title('Initial problem')
ax = gca;
ax.XAxisLocation = 'origin';
ax.YAxisLocation = 'origin';

plotregion(-A,-b,[],[],[0.8,0.8,0.8]); % plot the feasible region
obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
fcontour(obj,'--','LineWidth',2)

% Plot optimum

plot(x_qp(1),x_qp(2,end),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')


% Modify bounds

% b = b + [4;0;0;0];
b = b + [0.001;0;0;0;0];


options = optimoptions('quadprog','Algorithm','active-set','Display','off');
[x_qp,f_opt,exitflag,output,lambda] = quadprog(Q,h,A,b,[],[],[],[],[0;0],options);

% fprintf('Solution\n')
% disp(x_qp)
fprintf('Function value %.4e \n',f_opt)
fprintf('KKT multipliers \n')
disp(lambda.ineqlin')

% Plot the QP
figure(2),clf, hold on, box on, grid on, axis equal
xlabel('x_1');
ylabel('x_2');
title('Modified problem')
ax = gca;
ax.XAxisLocation = 'origin';
ax.YAxisLocation = 'origin';

plotregion(-A,-b,[],[],[0.8,0.8,0.8]); % plot the feasible region
obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
fcontour(obj,'--','LineWidth',2)

% Plot optimum

plot(x_qp(1),x_qp(2,end),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')


